package easik.ui.menu;

import java.io.File;

import javax.swing.filechooser.FileFilter;

import easik.EasikConstants;


/**
 * Filter for file browsing dialogs to ensure that only .xml files are accepted.
 * 
 * @author Rob Fletcher 2005
 */
public class XMLFileFilter extends FileFilter {
	/**
	 * Overloaded method, checks the file to see if it ends with .xml and returns true.
	 * false otherwise.
	 * 
	 * @param file The file being considered
	 * @return True if the file is of an accepatble type
	 */
	public boolean accept(File file) {
		if ( file.getName().endsWith(EasikConstants.XML_FILE) ) {
			return true; 
		}		
		if (file.isDirectory()) return true;		
		return false;	
	}
	
	/**
	 * The description of this filter. *.xml will do
	 * @return The description of this filter
	 */
	public String getDescription() {
		return "*" +EasikConstants.XML_FILE;
	}
}
